<?php
session_start();
require 'db.php';

// Yalnızca yöneticilerin erişimine izin ver
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// Kullanıcı ID'sini GET parametresinden al
$user_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Form gönderildiğinde güncelleme yap
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Formdan gelen profil bilgileri
    $full_name = $_POST['full_name'] ?? '';
    $about = $_POST['about'] ?? '';
    $website_url = $_POST['website_url'] ?? '';
    $products_link = $_POST['products_link'] ?? '';
    $contact_info = $_POST['contact_info'] ?? '';
    $location_link = $_POST['location_link'] ?? '';

    // Profil bilgilerini güncelle
    $stmt = $pdo->prepare("UPDATE profiles SET full_name = ?, about = ?, website_url = ?, products_link = ?, contact_info = ?, location_link = ? WHERE user_id = ?");
    $stmt->execute([$full_name, $about, $website_url, $products_link, $contact_info, $location_link, $user_id]);

    echo "<p>Profil bilgileri başarıyla güncellendi.</p>";
}

// Mevcut kullanıcı profil bilgilerini getir
$stmt = $pdo->prepare("SELECT * FROM profiles WHERE user_id = ?");
$stmt->execute([$user_id]);
$profile = $stmt->fetch();

if (!$profile) {
    exit('Profil bulunamadı.');
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta viewport="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Profili Düzenle</title>
</head>
<body>
    <h2>Kullanıcı Profili Düzenle</h2>

    <form action="" method="post">
        <label for="full_name">Tam Ad:</label>
        <input type="text" name="full_name" id="full_name" value="<?php echo htmlspecialchars($profile['full_name'] ?? ''); ?>">

        <label for="about">Hakkında:</label>
        <textarea name="about" id="about"><?php echo htmlspecialchars($profile['about'] ?? ''); ?></textarea>

        <label for="website_url">Web Sitesi URL:</label>
        <input type="url" name="website_url" id="website_url" value="<?php echo htmlspecialchars($profile['website_url'] ?? ''); ?>">

        <label for="products_link">Ürünler Linki:</label>
        <input type="url" name="products_link" id="products_link" value="<?php echo htmlspecialchars($profile['products_link'] ?? ''); ?>">

        <label for="contact_info">İletişim Bilgileri:</label>
        <input type="text" name="contact_info" id="contact_info" value="<?php echo htmlspecialchars($profile['contact_info'] ?? ''); ?>">

        <label for="location_link">Konum Linki:</label>
        <input type="url" name="location_link" id="location_link" value="<?php echo htmlspecialchars($profile['location_link'] ?? ''); ?>">

        <button type="submit">Güncelle</button>
    </form>

    <a href="admin.php">Geri Dön</a>
</body>
</html>
