<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

try {
    // SQL sorgusunu kullanarak cari_satislar, musteriler ve users tablolarını join ediyoruz
    $sql = "SELECT cari_satislar.id, musteriler.ad_soyad AS musteri_adi, cari_satislar.tarih, cari_satislar.fatura_no, 
            cari_satislar.urun_adi, cari_satislar.miktar, cari_satislar.fiyat, cari_satislar.kdv_orani, cari_satislar.kdv_tutari, 
            cari_satislar.toplam_tutar, cari_satislar.aciklama, 
            COALESCE(users.username, 'Bilinmeyen Kullanıcı') AS ekleyen_kullanici
            FROM cari_satislar 
            LEFT JOIN musteriler ON cari_satislar.musteri_id = musteriler.id 
            LEFT JOIN users ON cari_satislar.created_by = users.id";

    $stmt = $pdo->query($sql);
    $cari_satislar = $stmt->fetchAll();
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<style>
    .mobile-home-button {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        padding: 10px;
        background-color: #f8f9fa;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        z-index: 1000;
        text-align: center;
    }

    .mobile-home-button .btn {
        width: 90%;
        margin: 0 auto;
    }
</style>
<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                <h4 class="mb-4">Cari Satış Listesi</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Müşteri Adı</th>
                            <th>Tarih</th>
                            <th>Fatura No</th>
                            <th>Ürün Adı</th>
                            <th>Miktar</th>
                            <th>Fiyat</th>
                            <th>KDV Oranı</th>
                            <th>KDV Tutarı</th>
                            <th>Toplam Tutar</th>
                            <th>Açıklama</th>
                            <th>Ekleyen Kullanıcı</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($cari_satislar)): ?>
                            <tr><td colspan="13">Gösterilecek kayıt bulunamadı.</td></tr>
                        <?php else: ?>
                            <?php foreach ($cari_satislar as $satis): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($satis['id'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($satis['musteri_adi'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($satis['tarih'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($satis['fatura_no'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($satis['urun_adi'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($satis['miktar'] ?? ''); ?></td>
                                    <td><?php echo number_format($satis['fiyat'], 2, ',', '.') . ' TL'; ?></td>
                                    <td><?php echo htmlspecialchars($satis['kdv_orani'] ?? '') . '%'; ?></td>
                                    <td><?php echo number_format($satis['kdv_tutari'], 2, ',', '.') . ' TL'; ?></td>
                                    <td><?php echo number_format($satis['toplam_tutar'], 2, ',', '.') . ' TL'; ?></td>
                                    <td><?php echo htmlspecialchars($satis['aciklama'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($satis['ekleyen_kullanici'] ?? ''); ?></td>
                                    <td>
                                        <a href="cari_satis_duzenle.php?id=<?php echo $satis['id']; ?>" class="btn btn-primary btn-sm">Düzenle</a>
                                        <a href="cari_satis_sil.php?id=<?php echo $satis['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?')">Sil</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
