<?php
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

$firma_id = null;
$cari_alislar = [];
$odemeler = [];
$total_alis = 0;
$total_odeme = 0;

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['firma_id'])) {
    $firma_id = $_POST['firma_id'];

    // Seçilen firmaya ait cari alışları getirme
    $alis_sql = "SELECT * FROM cari_alislar WHERE firma_id = ?";
    $alis_stmt = $pdo->prepare($alis_sql);
    $alis_stmt->execute([$firma_id]);
    $cari_alislar = $alis_stmt->fetchAll();

    // Cari alışların toplamını hesapla
    foreach ($cari_alislar as $alis) {
        $total_alis += $alis['toplam_tutar'];
    }

    // Seçilen firmaya ait ödemeleri getirme
    $odeme_sql = "SELECT * FROM odemeler WHERE firma_id = ?";
    $odeme_stmt = $pdo->prepare($odeme_sql);
    $odeme_stmt->execute([$firma_id]);
    $odemeler = $odeme_stmt->fetchAll();

    // Ödemelerin toplamını hesapla
    foreach ($odemeler as $odeme) {
        $total_odeme += $odeme['tutar'];
    }

    // Kalan bakiye
    $kalan_bakiye = $total_alis - $total_odeme;
}

// Firma listesini veritabanından çek
$firma_sql = "SELECT id, firma_adi FROM firmalar";
$firma_stmt = $pdo->query($firma_sql);
$firmalar = $firma_stmt->fetchAll();
?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
    
       <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    </br>
</br></br>      <h4 class="fw-bold py-3 mb-4">Firma Cari Ekstre</h4>

                    <!-- Firma Seçim Formu -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="firma_id" class="form-label">Firma Seç</label>
                                    <select name="firma_id" class="form-select" id="firma_id" required>
                                        <option value="">Firma Seçin</option>
                                        <?php foreach ($firmalar as $firma): ?>
                                            <option value="<?php echo $firma['id']; ?>" <?php echo ($firma_id == $firma['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($firma['firma_adi']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">Ekstre Göster</button>
                            </form>
                        </div>
                    </div>

                    <?php if ($firma_id !== null): ?>
                    <!-- PDF Çıktı Al Butonu -->
                    <div class="mb-4 text-end">
                        <a href="firma_cari_ekstre_pdf.php?firma_id=<?php echo $firma_id; ?>" class="btn btn-secondary" target="_blank">PDF Çıktı Al</a>
                    </div>

                    <!-- Cari Alışlar ve Ödemeler Tablosu -->
                    <div class="card">
                        <div class="card-body">
                            <h5 class="fw-bold text-center text-success mb-3">CARİ ALIŞLAR</h5>
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Fatura No</th>
                                        <th>Ürün/Hizmet Adı</th>
                                        <th>Miktar</th>
                                        <th>Fiyat</th>
                                        <th>KDV Oranı</th>
                                        <th>Toplam Tutar</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($cari_alislar as $alis): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($alis['fatura_no']); ?></td>
                                            <td><?php echo htmlspecialchars($alis['urun_hizmet_adi']); ?></td>
                                            <td><?php echo htmlspecialchars($alis['miktar']); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($alis['fiyat'], 2)); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($alis['kdv_orani'], 2)); ?>%</td>
                                            <td><?php echo htmlspecialchars(number_format($alis['toplam_tutar'], 2)); ?></td>
                                            <td><?php echo htmlspecialchars($alis['tarih']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Toplam Cari Alış:</th>
                                        <th><?php echo htmlspecialchars(number_format($total_alis, 2)); ?> TL</th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>

                            <h5 class="fw-bold text-center text-danger mt-4 mb-3">ÖDEMELER</h5>
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>İşlem Türü</th>
                                        <th>Tutar</th>
                                        <th>Açıklama</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($odemeler as $odeme): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($odeme['islem_turu']); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($odeme['tutar'], 2)); ?> TL</td>
                                            <td><?php echo htmlspecialchars($odeme['aciklama']); ?></td>
                                            <td><?php echo htmlspecialchars($odeme['tarih']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="1" class="text-end">Toplam Ödeme:</th>
                                        <th><?php echo htmlspecialchars(number_format($total_odeme, 2)); ?> TL</th>
                                        <th colspan="2"></th>
                                    </tr>
                                </tfoot>
                            </table>

                            <!-- Bakiye Kısmı -->
                            <div class="mt-4 text-center">
                                <h3 class="fw-bold" style="font-size: 1.5rem;">Kalan Bakiye: <?php echo htmlspecialchars(number_format($kalan_bakiye, 2)); ?> TL</h3>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
