<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Düzenlenecek kaydın ID'sini al
$id = $_GET['id'];

// Mevcut kayıt bilgilerini çek
$sql = "SELECT * FROM resmi_cari_satislar WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$satis = $stmt->fetch();

// Eğer kayıt POST ile güncelleniyorsa
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'];
    $tarih = $_POST['tarih'];
    $fatura_no = $_POST['fatura_no'];
    $urun_adi = $_POST['urun_adi'];
    $miktar = $_POST['miktar'];
    $fiyat = $_POST['fiyat'];
    $kdv_orani = $_POST['kdv_orani'];
    $aciklama = $_POST['aciklama'];

    // Toplam tutarı hesapla
    $kdv_tutari = ($fiyat * $miktar) * ($kdv_orani / 100);
    $toplam_tutar = ($fiyat * $miktar) + $kdv_tutari;

    // Kayıt güncelleme sorgusu
    $sql = "UPDATE resmi_cari_satislar SET musteri_id = ?, tarih = ?, fatura_no = ?, urun_adi = ?, miktar = ?, fiyat = ?, kdv_orani = ?, kdv_tutari = ?, toplam_tutar = ?, aciklama = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$musteri_id, $tarih, $fatura_no, $urun_adi, $miktar, $fiyat, $kdv_orani, $kdv_tutari, $toplam_tutar, $aciklama, $id])) {
        $_SESSION['message'] = "Cari satış başarıyla güncellendi!";
    } else {
        $_SESSION['error'] = "Cari satış güncellenirken bir hata oluştu.";
    }

    header("Location: resmi_cari_satis_listesi.php");
    exit;
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>

<!-- Sayfa içeriği düzenleme formu ile aynı olacaktır. -->
  <style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
   <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                  </br>
</br></br>     <h4 class="mb-4">Resmi Cari Satış Düzenle</h4>
                <form method="POST">
                    <!-- Form alanları aynı, mevcut değerlerle dolu olacak -->
                    <div class="mb-3">
                        <label for="musteri_id" class="form-label">Müşteri Seç</label>
                        <select name="musteri_id" class="form-select" id="musteri_id" required>
                            <?php foreach ($musteriler as $musteri): ?>
                                <option value="<?php echo $musteri['id']; ?>" <?php if ($musteri['id'] == $satis['musteri_id']) echo 'selected'; ?>>
                                    <?php echo htmlspecialchars($musteri['ad_soyad']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="tarih" class="form-label">Tarih</label>
                        <input type="date" name="tarih" class="form-control" id="tarih" value="<?php echo htmlspecialchars($satis['tarih']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fatura_no" class="form-label">Fatura No</label>
                        <input type="text" name="fatura_no" class="form-control" id="fatura_no" value="<?php echo htmlspecialchars($satis['fatura_no']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="urun_adi" class="form-label">Ürün Adı</label>
                        <input type="text" name="urun_adi" class="form-control" id="urun_adi" value="<?php echo htmlspecialchars($satis['urun_adi']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="miktar" class="form-label">Miktar</label>
                        <input type="number" name="miktar" class="form-control" id="miktar" value="<?php echo htmlspecialchars($satis['miktar']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="fiyat" class="form-label">Fiyat</label>
                        <input type="number" name="fiyat" class="form-control" id="fiyat" step="0.01" value="<?php echo htmlspecialchars($satis['fiyat']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="kdv_orani" class="form-label">KDV Oranı (%)</label>
                        <input type="number" name="kdv_orani" class="form-control" id="kdv_orani" step="0.01" value="<?php echo htmlspecialchars($satis['kdv_orani']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label">Açıklama</label>
                        <textarea name="aciklama" class="form-control" id="aciklama"><?php echo htmlspecialchars($satis['aciklama']); ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
