<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

try {
    // SQL sorgusu: resmi_tahsilatlar, musteriler ve users tablolarını join ediyoruz
    $sql = "SELECT resmi_tahsilatlar.id, musteriler.ad_soyad AS musteri_adi, resmi_tahsilatlar.tarih, resmi_tahsilatlar.tutar, 
            resmi_tahsilatlar.islem_turu, resmi_tahsilatlar.evrak_no, resmi_tahsilatlar.aciklama, 
            COALESCE(users.username, 'Bilinmeyen Kullanıcı') AS ekleyen_kullanici
            FROM resmi_tahsilatlar 
            LEFT JOIN musteriler ON resmi_tahsilatlar.musteri_id = musteriler.id 
            LEFT JOIN users ON resmi_tahsilatlar.created_by = users.id";

    $stmt = $pdo->query($sql);
    $resmi_tahsilatlar = $stmt->fetchAll();
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
   <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                   </br>
</br></br>    <h4 class="mb-4">Resmi Tahsilat Listesi</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Müşteri Adı</th>
                            <th>Tarih</th>
                            <th>Tutar</th>
                            <th>İşlem Türü</th>
                            <th>Evrak No</th>
                            <th>Açıklama</th>
                            <th>Ekleyen Kullanıcı</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($resmi_tahsilatlar)): ?>
                            <tr><td colspan="9">Gösterilecek kayıt bulunamadı.</td></tr>
                        <?php else: ?>
                            <?php foreach ($resmi_tahsilatlar as $tahsilat): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($tahsilat['id'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['musteri_adi'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['tarih'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['tutar'] ?? '') . ' TL'; ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['islem_turu'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['evrak_no'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['aciklama'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($tahsilat['ekleyen_kullanici'] ?? ''); ?></td>
                                    <td>
                                        <a href="resmi_tahsilat_duzenle.php?id=<?php echo $tahsilat['id']; ?>" class="btn btn-primary btn-sm">Düzenle</a>
                                        <a href="resmi_tahsilat_sil.php?id=<?php echo $tahsilat['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?')">Sil</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
