<?php
session_start();
require 'db.php';

// Kullanıcı girişi ve yetkilendirme kontrolü
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$current_password = $_POST['current_password'];
$new_password = $_POST['new_password'];
$confirm_password = $_POST['confirm_password'];

// Yeni şifrelerin eşleşip eşleşmediğini kontrol edin
if ($new_password != $confirm_password) {
    echo "Yeni şifreler eşleşmiyor.";
    exit;
}

// Mevcut şifreyi doğrula
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!password_verify($current_password, $user['password'])) {
    echo "Mevcut şifre yanlış.";
    exit;
}

// Yeni şifreyi hash'le ve güncelle
$hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
$stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
$stmt->execute([$hashed_password, $user_id]);

echo "Şifre başarıyla güncellendi.";
?>
