<?php
// db.php — Güvenli PDO bağlantısı (InnoDB, utf8mb4_turkish_ci)
$DB_HOST = 'localhost';
$DB_NAME = 'mrt';
$DB_USER = 'root';     // üretimde ayrı bir user oluşturun, minimum yetkilerle
$DB_PASS = '';
$DB_DSN  = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";

$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // güvenli hata modu
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,                  // gerçek prepared statements
];

try {
    $pdo = new PDO($DB_DSN, $DB_USER, $DB_PASS, $options);
    // Oturum izolasyonu ve InnoDB güvenliği zaten varsayılan.
} catch (PDOException $e) {
    // Üretimde ham hata mesajını göstermeyin
    http_response_code(500);
    exit('Veritabanı bağlantı hatası.');
}
