<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// Kullanıcıları veritabanından çek
$sql = "SELECT id, username, email, role FROM users";
$stmt = $pdo->query($sql);
$users = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetici Paneli</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h1>Yönetici Paneli</h1>
    <table>
        <tr>
            <th>Kullanıcı Adı</th>
            <th>E-posta</th>
            <th>Rol</th>
            <th>İşlemler</th>
        </tr>
        <?php foreach ($users as $user): ?>
            <tr>
                <td><?php echo htmlspecialchars($user['username']); ?></td>
                <td><?php echo htmlspecialchars($user['email']); ?></td>
                <td><?php echo htmlspecialchars($user['role']); ?></td>
                <td>
                    <a href="edit_user.php?id=<?php echo $user['id']; ?>">Düzenle</a> |
                    <a href="delete_user.php?id=<?php echo $user['id']; ?>">Sil</a>
                </td>
				   <td>
                        <a href="profile.php?user_id=<?php echo $user['id']; ?>">Profil Linki</a>
                        <!-- Diğer düzenleme veya silme işlemleri için bağlantılar -->
                    </td>
					<td>
    <a href="edit_user_profile.php?id=<?php echo $user['id']; ?>">Profil Sayfası Düzenle</a>
</td>
					
			
					
            </tr>
        <?php endforeach; ?>
    </table>		  <a href="logout.php">Çıkış Yap</a>
</body>
</html>
