<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Sadece admin ve user rolleri erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Firma listesini veritabanından çek
$sql = "SELECT id, firma_adi FROM firmalar";
$stmt = $pdo->query($sql);
$firmalar = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $firma_id = $_POST['firma_id'];
    $fatura_no = $_POST['fatura_no'];
    $urun_hizmet_adi = $_POST['urun_hizmet_adi'];
    $miktar = $_POST['miktar'];
    $fiyat = str_replace('.', '', $_POST['fiyat']); // Binlik ayraçları kaldır
    $fiyat = str_replace(',', '.', $fiyat); // Ondalık ayıracı dönüştür
    $kdv_orani = $_POST['kdv_orani'];
    $tarih = $_POST['tarih'];  // Formdan gelen tarih
    $aciklama = $_POST['aciklama'];

    // Oturumdan kullanıcı kimliğini alın
    $created_by = $_SESSION['user_id']; // Ekleyen kullanıcı kimliği

    // Toplam tutar hesaplama
    $ara_toplam = $miktar * $fiyat;
    $kdv_tutari = ($ara_toplam * $kdv_orani) / 100;
    $toplam_tutar = $ara_toplam + $kdv_tutari;

    // Veritabanına ekleme
    $sql = "INSERT INTO cari_alislar (firma_id, fatura_no, urun_hizmet_adi, miktar, fiyat, kdv_orani, toplam_tutar, aciklama, tarih, created_by) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);

    // Kullanıcı kimliği de dahil edilerek veriler veritabanına eklenir
    if ($stmt->execute([$firma_id, $fatura_no, $urun_hizmet_adi, $miktar, $fiyat, $kdv_orani, $toplam_tutar, $aciklama, $tarih, $created_by])) {
        $_SESSION['message'] = "Cari alış işlemi başarıyla kaydedildi!";
    } else {
        $_SESSION['error'] = "Cari alış işlemi kaydedilirken bir hata oluştu.";
    }

    header("Location: cari_alis_ekle.php");
    exit;
}
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cari Alış Ekle</title>
    <!-- jQuery kütüphanesi -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Gerekli stil ve script dosyalarını buraya ekleyin -->
</head>
<body>
<div class="layout-wrapper layout-content-navbar">
     <div class="mobile-home-button d-block d-lg-none">
        <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
    </div>
    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="fw-bold py-3 mb-4">Cari Alış Ekle</h4>

                    <!-- Uyarı Mesajları -->
                    <?php if (isset($_SESSION['message'])): ?>
                        <div class="alert alert-success">
                            <?php echo htmlspecialchars($_SESSION['message']); ?>
                        </div>
                        <?php unset($_SESSION['message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger">
                            <?php echo htmlspecialchars($_SESSION['error']); ?>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <!-- Cari Alış Ekleme Formu -->
                    <div class="card">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="firma_id" class="form-label">Firma Seç</label>
                                    <select name="firma_id" class="form-select" id="firma_id" required>
                                        <option value="">Firma Seçin</option>
                                        <?php foreach ($firmalar as $firma): ?>
                                            <option value="<?php echo $firma['id']; ?>">
                                                <?php echo htmlspecialchars($firma['firma_adi']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="fatura_no" class="form-label">Fatura No</label>
                                    <input type="text" name="fatura_no" class="form-control" id="fatura_no" required>
                                </div>
                                <div class="mb-3">
                                    <label for="urun_hizmet_adi" class="form-label">Ürün/Hizmet Adı</label>
                                    <input type="text" name="urun_hizmet_adi" class="form-control" id="urun_hizmet_adi" required>
                                </div>
                            <div class="mb-3">
    <label for="miktar" class="form-label">Miktar</label>
    <input type="number" name="miktar" class="form-control" id="miktar" step="0.01" required>
</div>

                                <div class="mb-3">
                                    <label for="fiyat" class="form-label">Fiyat</label>
                                    <input type="text" step="0.01" name="fiyat" class="form-control" id="fiyat" required>
                                </div>
                                <div class="mb-3">
                                    <label for="kdv_orani" class="form-label">KDV Oranı (%)</label>
                                    <input type="number" step="0.01" name="kdv_orani" class="form-control" id="kdv_orani" required>
                                </div>
                                <div class="mb-3">
                                    <label for="tarih" class="form-label">Tarih</label>
                                    <input type="date" name="tarih" class="form-control" id="tarih" required>
                                </div>
                                <div class="mb-3">
                                    <label for="toplam_tutar" class="form-label">Toplam Tutar</label>
                                    <input type="text" class="form-control" id="toplam_tutar" disabled>
                                </div>
                                <div class="mb-3">
                                    <label for="aciklama" class="form-label">Açıklama</label>
                                    <textarea name="aciklama" class="form-control" id="aciklama" rows="3"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Cari Alış Ekle</button>
                            </form>
                        </div>
                    </div>

                    <!-- Tutar Alanlarını Formatlama ve Toplam Tutar Hesaplama -->
                    <script>
                        $(document).ready(function() {
                            function formatNumber(num) {
                                return num.toLocaleString('tr-TR', {
                                    minimumFractionDigits: 2,
                                    maximumFractionDigits: 2
                                });
                            }

                            function hesaplaToplamTutar() {
                                var miktar = parseFloat($('#miktar').val()) || 0;
                                var fiyat = parseFloat($('#fiyat').val().replace(/\./g, '').replace(',', '.')) || 0;
                                var kdv_orani = parseFloat($('#kdv_orani').val()) || 0;

                                var ara_toplam = miktar * fiyat;
                                var kdv_tutari = (ara_toplam * kdv_orani) / 100;
                                var toplam_tutar = ara_toplam + kdv_tutari;

                                $('#toplam_tutar').val(formatNumber(toplam_tutar) + ' TL');
                            }

                            $('#miktar, #fiyat, #kdv_orani').on('input', hesaplaToplamTutar);

                            $('#fiyat').on('input', function() {
                                let value = $(this).val().replace(/[^0-9]/g, '');
                                value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                                $(this).val(value);
                            });
                        });
                    </script>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
