<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

try {
    // SQL sorgusu ile çek kayıtlarını ve kullanıcı bilgilerini alıyoruz
    $sql = "SELECT cekler.id, cekler.cek_adi, cekler.cek_no, cekler.alinan_tarih, cekler.tutar, cekler.cirocu, cekler.verilen_yer, 
                   cekler.vade_tarihi, cekler.banka_bilgisi, 
                   COALESCE(users.username, 'Bilinmeyen Kullanıcı') AS ekleyen_kullanici
            FROM cekler
            LEFT JOIN users ON cekler.created_by = users.id";

    $stmt = $pdo->query($sql);
    $cekler = $stmt->fetchAll();
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<style>
.mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}
</style>
<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                </br></br></br>
                <h4 class="mb-4">Çek Listesi</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Çek Adı</th> <!-- Yeni sütun başlığı -->
                            <th>Çek No</th>
                            <th>Alınan Tarih</th>
                            <th>Tutar</th>
                            <th>Cirocu</th>
                            <th>Verilen Yer</th>
                            <th>Vade Tarihi</th>
                            <th>Banka Bilgisi</th>
                            <th>Ekleyen Kullanıcı</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($cekler)): ?>
                            <tr><td colspan="11">Gösterilecek kayıt bulunamadı.</td></tr> <!-- colspan güncellendi -->
                        <?php else: ?>
                            <?php foreach ($cekler as $cek): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($cek['id'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($cek['cek_adi'] ?? ''); ?></td> <!-- Çek Adı alanı eklendi -->
                                    <td><?php echo htmlspecialchars($cek['cek_no'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($cek['alinan_tarih'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars(number_format($cek['tutar'], 2, ',', '.')) . ' TL'; ?></td> <!-- Tutar alanı formatlandı -->
                                    <td><?php echo htmlspecialchars($cek['cirocu'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($cek['verilen_yer'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($cek['vade_tarihi'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($cek['banka_bilgisi'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($cek['ekleyen_kullanici'] ?? ''); ?></td>
                                    <td>
                                        <a href="cek_duzenle.php?id=<?php echo $cek['id']; ?>" class="btn btn-primary btn-sm">Düzenle</a>
                                        <a href="cek_sil.php?id=<?php echo $cek['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu çeki silmek istediğinizden emin misiniz?')">Sil</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
