<?php
require 'db.php';
require_once('tcpdf/tcpdf.php');

if (!isset($_GET['firma_id'])) {
    die("Geçersiz Firma ID'si");
}

$firma_id = $_GET['firma_id'];

// Firma bilgilerini al
$firma_sql = "SELECT firma_adi FROM firmalar WHERE id = ?";
$firma_stmt = $pdo->prepare($firma_sql);
$firma_stmt->execute([$firma_id]);
$firma = $firma_stmt->fetch();

if (!$firma) {
    die("Firma bulunamadı");
}

// Cari alış ve ödeme kayıtlarını al
$alis_sql = "SELECT * FROM cari_alislar WHERE firma_id = ?";
$alis_stmt = $pdo->prepare($alis_sql);
$alis_stmt->execute([$firma_id]);
$cari_alislar = $alis_stmt->fetchAll();

$odeme_sql = "SELECT * FROM odemeler WHERE firma_id = ?";
$odeme_stmt = $pdo->prepare($odeme_sql);
$odeme_stmt->execute([$firma_id]);
$odemeler = $odeme_stmt->fetchAll();

// Toplamları hesapla
$total_alis = 0;
foreach ($cari_alislar as $alis) {
    $total_alis += $alis['toplam_tutar'];
}

$total_odeme = 0;
foreach ($odemeler as $odeme) {
    $total_odeme += $odeme['tutar'];
}

$kalan_bakiye = $total_alis - $total_odeme;

// TCPDF ayarları
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Firma Cari Ekstre');
$pdf->SetTitle('Firma Cari Ekstre');
$pdf->SetHeaderData('', 0, 'Firma Cari Ekstre', $firma['firma_adi']);
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->AddPage();

// Türkçe karakterler için DejaVuSans fontunu yükle
$pdf->SetFont('dejavusans', '', 12);

// İçerik ekle
$html = '<h1>Firma Cari Ekstre</h1>';
$html .= '<h2>Firma: ' . htmlspecialchars($firma['firma_adi']) . '</h2>';

// Cari Alışlar
$html .= '<h3>Cari Alışlar</h3>';
$html .= '<table border="1" cellpadding="5">';
$html .= '<tr>
            <th>Fatura No</th>
            <th>Ürün/Hizmet Adı</th>
            <th>Miktar</th>
            <th>Fiyat</th>
            <th>KDV Oranı</th>
            <th>Toplam Tutar</th>
            <th>Tarih</th>
          </tr>';

foreach ($cari_alislar as $alis) {
    $html .= '<tr>
                <td>' . htmlspecialchars($alis['fatura_no']) . '</td>
                <td>' . htmlspecialchars($alis['urun_hizmet_adi']) . '</td>
                <td>' . htmlspecialchars($alis['miktar']) . '</td>
                <td>' . htmlspecialchars(number_format($alis['fiyat'], 2)) . '</td>
                <td>' . htmlspecialchars(number_format($alis['kdv_orani'], 2)) . '%</td>
                <td>' . htmlspecialchars(number_format($alis['toplam_tutar'], 2)) . '</td>
                <td>' . htmlspecialchars($alis['tarih']) . '</td>
              </tr>';
}

$html .= '</table>';
$html .= '<p>Toplam Cari Alış: ' . htmlspecialchars(number_format($total_alis, 2)) . ' TL</p>';

// Ödemeler
$html .= '<h3>Ödemeler</h3>';
$html .= '<table border="1" cellpadding="5">';
$html .= '<tr>
            <th>İşlem Türü</th>
            <th>Tutar</th>
            <th>Açıklama</th>
            <th>Tarih</th>
          </tr>';

foreach ($odemeler as $odeme) {
    $html .= '<tr>
                <td>' . htmlspecialchars($odeme['islem_turu']) . '</td>
                <td>' . htmlspecialchars(number_format($odeme['tutar'], 2)) . ' TL</td>
                <td>' . htmlspecialchars($odeme['aciklama']) . '</td>
                <td>' . htmlspecialchars($odeme['tarih']) . '</td>
              </tr>';
}

$html .= '</table>';
$html .= '<p>Toplam Ödeme: ' . htmlspecialchars(number_format($total_odeme, 2)) . ' TL</p>';

// Kalan Bakiye
$html .= '<h3>Kalan Bakiye: ' . htmlspecialchars(number_format($kalan_bakiye, 2)) . ' TL</h3>';

$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('firma_cari_ekstre.pdf', 'I');
