<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Firma listesini veritabanından çek
$sql = "SELECT id, firma_adi FROM firmalar";
$stmt = $pdo->query($sql);
$firmalar = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $firma_id = $_POST['firma_id'];
    $tarih = $_POST['tarih'];
    $tutar = str_replace('.', '', $_POST['tutar']); // Binlik ayraçları kaldır
    $tutar = str_replace(',', '.', $tutar); // Ondalık ayıracı dönüştür
    $islem_turu = $_POST['islem_turu'];
    $aciklama = $_POST['aciklama'];
    
    // Oturum açmış kullanıcının ID'sini al
    $created_by = $_SESSION['user_id'];

    // SQL sorgusunu updated
    $sql = "INSERT INTO odemeler (firma_id, tarih, tutar, islem_turu, aciklama, created_by) 
            VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);

    // Verileri sorguya ekleyerek çalıştır
    if ($stmt->execute([$firma_id, $tarih, $tutar, $islem_turu, $aciklama, $created_by])) {
        $_SESSION['message'] = "Ödeme başarıyla kaydedildi!";
    } else {
        $_SESSION['error'] = "Ödeme kaydedilirken bir hata oluştu.";
    }

    header("Location: odeme_ekle.php");
    exit;
}
ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
    <div class="mobile-home-button d-block d-lg-none">
        <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
    </div>

    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                    <h4 class="fw-bold py-3 mb-4">Ödeme Ekle</h4>

                    <!-- Uyarı Mesajları -->
                    <?php if (isset($_SESSION['message'])): ?>
                        <div class="alert alert-success">
                            <?php echo htmlspecialchars($_SESSION['message']); ?>
                        </div>
                        <?php unset($_SESSION['message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error'])): ?>
                        <div class="alert alert-danger">
                            <?php echo htmlspecialchars($_SESSION['error']); ?>
                        </div>
                        <?php unset($_SESSION['error']); ?>
                    <?php endif; ?>

                    <!-- Ödeme Ekleme Formu -->
                    <div class="card">
                        <div class="card-body">
                            <form method="POST">
                                <div class="mb-3">
                                    <label for="firma_id" class="form-label">Firma Seç</label>
                                    <select name="firma_id" class="form-select" id="firma_id" required>
                                        <option value="">Firma Seçin</option>
                                        <?php foreach ($firmalar as $firma): ?>
                                            <option value="<?php echo $firma['id']; ?>">
                                                <?php echo htmlspecialchars($firma['firma_adi']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="tarih" class="form-label">Tarih</label>
                                    <input type="date" name="tarih" class="form-control" id="tarih" required>
                                </div>
                                <div class="mb-3">
                                    <label for="tutar" class="form-label">Tutar</label>
                                    <input type="text" name="tutar" class="form-control" id="tutar" required>
                                </div>
                                <div class="mb-3">
                                    <label for="islem_turu" class="form-label">İşlem Türü</label>
                                    <select name="islem_turu" class="form-select" id="islem_turu" required>
                                        <option value="nakit">Nakit</option>
                                        <option value="havale">Havale</option>
                                        <option value="kredi kartı">Kredi Kartı</option>
                                        <option value="çek">Çek</option>
                                        <option value="senet">Senet</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="aciklama" class="form-label">Açıklama</label>
                                    <textarea name="aciklama" class="form-control" id="aciklama" rows="3"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Ödeme Ekle</button>
                            </form>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tutar Alanını Formatlama -->
<script>
$(document).ready(function() {
    $('#tutar').on('input', function() {
        let value = $(this).val().replace(/[^0-9]/g, ''); // Sadece rakamları al
        value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.'); // Her üç hanede bir nokta koy
        $(this).val(value); // Formatlanmış değeri input alanına yaz
    });
});
</script>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
