<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

try {
    // SQL sorgusunu kullanarak odemeler, firmalar ve users tablolarını join ediyoruz
    $sql = "SELECT odemeler.id, firmalar.firma_adi, odemeler.tarih, odemeler.tutar, odemeler.islem_turu, odemeler.aciklama, 
            COALESCE(users.username, 'Bilinmeyen Kullanıcı') AS ekleyen_kullanici
            FROM odemeler 
            LEFT JOIN firmalar ON odemeler.firma_id = firmalar.id 
            LEFT JOIN users ON odemeler.created_by = users.id";

    $stmt = $pdo->query($sql);
    $odemeler = $stmt->fetchAll();
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage();
}
?>

<style>
    .mobile-home-button {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        padding: 10px;
        background-color: #f8f9fa;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        z-index: 1000;
        text-align: center;
    }

    .mobile-home-button .btn {
        width: 90%;
        margin: 0 auto;
    }
</style>
<div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                <h4 class="mb-4">Ödeme Listesi</h4>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Firma Adı</th>
                            <th>Tarih</th>
                            <th>Tutar</th>
                            <th>İşlem Türü</th>
                            <th>Açıklama</th>
                            <th>Ekleyen Kullanıcı</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($odemeler)): ?>
                            <tr><td colspan="8">Gösterilecek kayıt bulunamadı.</td></tr>
                        <?php else: ?>
                            <?php foreach ($odemeler as $odeme): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($odeme['id'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($odeme['firma_adi'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($odeme['tarih'] ?? ''); ?></td>
                                    <td><?php echo number_format($odeme['tutar'], 2, ',', '.') . ' TL'; ?></td>
                                    <td><?php echo htmlspecialchars($odeme['islem_turu'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($odeme['aciklama'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($odeme['ekleyen_kullanici'] ?? ''); ?></td>
                                    <td>
                                        <a href="odeme_duzenle.php?id=<?php echo $odeme['id']; ?>" class="btn btn-primary btn-sm">Düzenle</a>
                                        <a href="odeme_sil.php?id=<?php echo $odeme['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Bu kaydı silmek istediğinizden emin misiniz?')">Sil</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
