<?php
session_start();
require 'db.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// URL'den ID'yi al
$id = $_GET['id'] ?? null;

if (!$id) {
    echo "Geçersiz ID.";
    exit;
}

// Ödeme kaydını sil
$sql = "DELETE FROM odemeler WHERE id = ?";
$stmt = $pdo->prepare($sql);

if ($stmt->execute([$id])) {
    $_SESSION['message'] = "Ödeme kaydı başarıyla silindi!";
} else {
    $_SESSION['error'] = "Silme işlemi sırasında bir hata oluştu.";
}

header("Location: odeme_listesi.php");
exit;
?>
