<?php
session_start();
require 'db.php';
include 'sidebar.php'; 
include 'header.php'; 

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

// Tüm müşteriler için genel borç durumu
$sql = "
SELECT 
    m.id,
    m.ad_soyad,
    COALESCE(SUM(rcs.toplam_tutar), 0) AS toplam_satis,
    COALESCE((SELECT SUM(rt.tutar) FROM resmi_tahsilatlar rt WHERE rt.musteri_id = m.id), 0) AS toplam_tahsilat,
    COALESCE(SUM(rcs.toplam_tutar), 0) - COALESCE((SELECT SUM(rt.tutar) FROM resmi_tahsilatlar rt WHERE rt.musteri_id = m.id), 0) AS bakiye
FROM 
    musteriler m
LEFT JOIN 
    resmi_cari_satislar rcs ON m.id = rcs.musteri_id
GROUP BY 
    m.id, m.ad_soyad
";

$stmt = $pdo->query($sql);
$musteriler = $stmt->fetchAll();

// Toplamlar için değişkenler
$toplam_satis = 0;
$toplam_tahsilat = 0;
$toplam_bakiye = 0;

foreach ($musteriler as $musteri) {
    $toplam_satis += $musteri['toplam_satis'];
    $toplam_tahsilat += $musteri['toplam_tahsilat'];
    $toplam_bakiye += $musteri['bakiye'];
}

?>
<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
<div class="layout-wrapper layout-content-navbar">
      <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>
    <div class="layout-container">
        <div class="layout-page">
            <div class="content-wrapper">
                <div class="container-xxl flex-grow-1 container-p-y">
                         </br>
</br></br>  <h4 class="fw-bold py-3 mb-4">Resmi Müşteri Genel Borç Durumu</h4>

                    <!-- Müşteri Genel Borç Tablosu -->
                    <div class="card">
                        <div class="card-body">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Müşteri Adı</th>
                                        <th>Toplam Satış</th>
                                        <th>Toplam Tahsilat</th>
                                        <th>Bakiye</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($musteriler as $musteri): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($musteri['ad_soyad']); ?></td>
                                            <td><?php echo htmlspecialchars(number_format($musteri['toplam_satis'], 2)); ?> TL</td>
                                            <td><?php echo htmlspecialchars(number_format($musteri['toplam_tahsilat'], 2)); ?> TL</td>
                                            <td><?php echo htmlspecialchars(number_format($musteri['bakiye'], 2)); ?> TL</td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Toplamlar</th>
                                        <th><?php echo htmlspecialchars(number_format($toplam_satis, 2)); ?> TL</th>
                                        <th><?php echo htmlspecialchars(number_format($toplam_tahsilat, 2)); ?> TL</th>
                                        <th>
                                            <span style="font-size: 18px; font-weight: bold;"><?php echo htmlspecialchars(number_format($toplam_bakiye, 2)); ?> TL</span>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <!-- PDF Çıktı Al Butonu -->
                    <div class="mt-4">
                        <a href="resmi_musteri_genel_borc_pdf.php" target="_blank" class="btn btn-danger">PDF Çıktı Al</a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Bootstrap ve diğer kütüphanelerin JavaScript dosyaları -->
<script src="../assets/vendor/libs/jquery/jquery.js"></script>
<script src="../assets/vendor/libs/popper/popper.js"></script>
<script src="../assets/vendor/js/bootstrap.js"></script>
<script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="../assets/vendor/js/menu.js"></script>
<script src="../assets/js/main.js"></script>
</body>
</html>
