<?php
ob_start(); // Tamponlama başlatılıyor
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require 'db.php';
include 'sidebar.php';
include 'header.php';

// Yalnızca admin ve user erişebilir
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'user')) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    header("Location: tahsilat_listesi.php");
    exit;
}

$id = $_GET['id'];

// Mevcut tahsilat bilgilerini veritabanından çek
$sql = "SELECT * FROM tahsilatlar WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$tahsilat = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $musteri_id = $_POST['musteri_id'];
    $tarih = $_POST['tarih'];
    $tutar = $_POST['tutar'];
    $islem_turu = $_POST['islem_turu'];
    $evrak_no = $_POST['evrak_no'];
    $aciklama = $_POST['aciklama'];

    $sql = "UPDATE tahsilatlar SET musteri_id = ?, tarih = ?, tutar = ?, islem_turu = ?, evrak_no = ?, aciklama = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    if ($stmt->execute([$musteri_id, $tarih, $tutar, $islem_turu, $evrak_no, $aciklama, $id])) {
        $_SESSION['message'] = "Tahsilat başarıyla güncellendi!";
    } else {
        $_SESSION['error'] = "Tahsilat güncellenirken bir hata oluştu.";
    }

    header("Location: tahsilat_listesi.php");
    exit;
}

// Müşteri listesini veritabanından çek
$musteri_sql = "SELECT id, ad_soyad FROM musteriler";
$musteri_stmt = $pdo->query($musteri_sql);
$musteriler = $musteri_stmt->fetchAll();

ob_end_flush(); // Tamponları serbest bırak ve ekrana yazdır
?>

<style>
    
    .mobile-home-button {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    padding: 10px;
    background-color: #f8f9fa;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    z-index: 1000;
    text-align: center;
}

.mobile-home-button .btn {
    width: 90%;
    margin: 0 auto;
}

</style>
   <div class="mobile-home-button d-block d-lg-none">
    <a href="admin.php" class="btn btn-primary btn-lg w-100">Anasayfa</a>
</div>

<div class="layout-container">
    <div class="layout-page">
        <div class="content-wrapper">
            <div class="container mt-5">
                </br>
</br></br>   <h4 class="mb-4">Tahsilat Düzenle</h4>
                <form action="" method="post">
                    <div class="mb-3">
                        <label for="musteri_id" class="form-label">Müşteri:</label>
                        <select name="musteri_id" class="form-control" required>
                            <?php foreach ($musteriler as $musteri): ?>
                                <option value="<?php echo $musteri['id']; ?>" <?php if ($tahsilat['musteri_id'] == $musteri['id']) echo 'selected'; ?>>
                                    <?php echo htmlspecialchars($musteri['ad_soyad']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="tarih" class="form-label">Tarih:</label>
                        <input type="date" name="tarih" class="form-control" value="<?php echo htmlspecialchars($tahsilat['tarih']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="tutar" class="form-label">Tutar:</label>
                        <input type="number" name="tutar" class="form-control" step="0.01" value="<?php echo htmlspecialchars($tahsilat['tutar']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="islem_turu" class="form-label">İşlem Türü:</label>
                        <input type="text" name="islem_turu" class="form-control" value="<?php echo htmlspecialchars($tahsilat['islem_turu']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="evrak_no" class="form-label">Evrak No:</label>
                        <input type="text" name="evrak_no" class="form-control" value="<?php echo htmlspecialchars($tahsilat['evrak_no']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label">Açıklama:</label>
                        <textarea name="aciklama" class="form-control"><?php echo htmlspecialchars($tahsilat['aciklama']); ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Güncelle</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
